#!/bin/bash
CONF_FILE="/etc/sysctl.d/55-hcps.conf"

NOT_NEEDED="Configuration is correct. No update is required."
ALREADY_UPDATED="Configuration file was already updated. Applying update to the kernel."
APPLIED_SUCCESS="Update completed successfully!"
APPLIED_FAILED="Update failed. Contact customer support."

logFile="/var/rhino/logs/mgmt_net_rp_filter.log"

logAndEcho(){
    local msg="$1"
    echo "$msg"
    echo "$msg" >> "$logFile"
}

log(){
    local msg="$1"
    echo "$msg" >> "$logFile"
}

if [[ "a$(sysctl -n net.ipv4.conf.all.rp_filter)" == "a2" ]] ; then 
   logAndEcho "${NOT_NEEDED}"
   exit 0
fi
if grep -q "all.rp_filter" ${CONF_FILE} ; then
   log "${ALREADY_UPDATED}"
else
   sed -i -e "s/default/all/" ${CONF_FILE}
fi
sysctl -p ${CONF_FILE}
if [[ "a$(sysctl -n net.ipv4.conf.all.rp_filter)" == "a2" ]] ; then 
   logAndEcho "${APPLIED_SUCCESS}"
   exit 0
else
   logAndEcho "${APPLIED_FAILED}"
   exit 255
fi
